/*
 * Globalize Culture zh-TW
 *
 * http://github.com/jquery/globalize
 *
 * Copyright Software Freedom Conservancy, Inc.
 * Dual licensed under the MIT or GPL Version 2 licenses.
 * http://jquery.org/license
 *
 * This file was generated by the Globalize Culture Generator
 * Translation: bugs found in this file need to be fixed in the generator
 */

(function( window, undefined ) {

var Globalize;

if ( typeof require !== "undefined" &&
	typeof exports !== "undefined" &&
	typeof module !== "undefined" ) {
	// Assume CommonJS
	Globalize = require( "globalize" );
} else {
	// Global variable
	Globalize = window.Globalize;
}

Globalize.addCultureInfo( "zh-TW", "default", {
	name: "zh-TW",
	englishName: "Chinese (Traditional, Taiwan)",
	nativeName: "中文(台灣)",
	language: "zh-CHT",
	numberFormat: {
		"NaN": "不是一個數字",
		negativeInfinity: "負無窮大",
		positiveInfinity: "正無窮大",
		percent: {
			pattern: ["-n%","n%"]
		},
		currency: {
			pattern: ["-$n","$n"],
			symbol: "NT$"
		}
	},
	calendars: {
		standard: {
			days: {
				names: ["星期日","星期一","星期二","星期三","星期四","星期五","星期六"],
				namesAbbr: ["週日","週一","週二","週三","週四","週五","週六"],
				namesShort: ["日","一","二","三","四","五","六"]
			},
			months: {
				names: ["一月","二月","三月","四月","五月","六月","七月","八月","九月","十月","十一月","十二月",""],
				namesAbbr: ["一月","二月","三月","四月","五月","六月","七月","八月","九月","十月","十一月","十二月",""]
			},
			AM: ["上午","上午","上午"],
			PM: ["下午","下午","下午"],
			eras: [{"name":"西元","start":null,"offset":0}],
			patterns: {
				d: "yyyy/M/d",
				D: "yyyy'年'M'月'd'日'",
				t: "tt hh:mm",
				T: "tt hh:mm:ss",
				f: "yyyy'年'M'月'd'日' tt hh:mm",
				F: "yyyy'年'M'月'd'日' tt hh:mm:ss",
				M: "M'月'd'日'",
				Y: "yyyy'年'M'月'"
			}
		},
		Taiwan: {
			name: "Taiwan",
			days: {
				names: ["星期日","星期一","星期二","星期三","星期四","星期五","星期六"],
				namesAbbr: ["週日","週一","週二","週三","週四","週五","週六"],
				namesShort: ["日","一","二","三","四","五","六"]
			},
			months: {
				names: ["一月","二月","三月","四月","五月","六月","七月","八月","九月","十月","十一月","十二月",""],
				namesAbbr: ["一月","二月","三月","四月","五月","六月","七月","八月","九月","十月","十一月","十二月",""]
			},
			AM: ["上午","上午","上午"],
			PM: ["下午","下午","下午"],
			eras: [{"name":"","start":null,"offset":1911}],
			twoDigitYearMax: 99,
			patterns: {
				d: "yyyy/M/d",
				D: "yyyy'年'M'月'd'日'",
				t: "tt hh:mm",
				T: "tt hh:mm:ss",
				f: "yyyy'年'M'月'd'日' tt hh:mm",
				F: "yyyy'年'M'月'd'日' tt hh:mm:ss",
				M: "M'月'd'日'",
				Y: "yyyy'年'M'月'"
			}
		}
	}
});

}( this ));
(function() {
var merge = function(obj1, obj2) {
  var obj3 = {};
  for(var attrname in obj1){obj3[attrname] = obj1[attrname]; }
  for(var attrname in obj2){obj3[attrname] = obj2[attrname]; }
  return obj3;
}
var dict = {
  "box user": "用戶",
  "filetype_box user": "用戶",
  "html": "HTML文件",
  "filetype_html": "HTML文件",
  "wiki": "WiKi",
  "filetype_wiki": "WiKi",
  "webscraperwebpage": "網頁",
  "filetype_webscraperwebpage": "網頁",
  "image": "影像",
  "filetype_image": "影像",
  "folder": "資料夾",
  "filetype_folder": "資料夾",
  "txt": "文本",
  "filetype_txt": "文本",
  "zip": "Zip文件",
  "filetype_zip": "Zip文件",
  "olefile": "OLE文件",
  "filetype_olefile": "OLE文件",
  "gmailmessage": "Gmail訊息",
  "filetype_gmailmessage": "Gmail訊息",
  "pdf": "PDF文件",
  "filetype_pdf": "PDF文件",
  "swf": "Flash文件",
  "filetype_swf": "Flash文件",
  "xml": "XML文件",
  "filetype_xml": "XML文件",
  "vsd": "Visio",
  "filetype_vsd": "Visio",
  "svg": "SVG",
  "filetype_svg": "SVG",
  "svm": "Open Office",
  "filetype_svm": "Open Office",
  "rssitem": "RSS 訂閱",
  "filetype_rssitem": "RSS 訂閱",
  "doc": "文檔",
  "filetype_doc": "文檔",
  "docx": "Microsoft Word 文檔",
  "filetype_docx": "Microsoft Word 文檔",
  "xls": "試算表文文件",
  "filetype_xls": "試算表文文件",
  "ppt": "演示視窗",
  "filetype_ppt": "演示視窗",
  "video": "視頻",
  "filetype_video": "視頻",
  "saleforceitem": "Salesforce",
  "filetype_saleforceitem": "Salesforce",
  "dynamicscrmitem": "Dynamics CRM",
  "filetype_dynamicscrmitem": "Dynamics CRM",
  "salesforceitem": "Salesforce",
  "filetype_salesforceitem": "Salesforce",
  "odt": "打開文本文檔",
  "filetype_odt": "打開文本文檔",
  "lithiummessage": "Lithium 訊息",
  "filetype_lithiummessage": "Lithium 訊息",
  "lithiumthread": "Lithium 執行緒",
  "filetype_lithiumthread": "Lithium 執行緒",
  "lithiumboard": "Lithium 寫字板",
  "filetype_lithiumboard": "Lithium 寫字板",
  "lithiumcategory": "Lithium 類別",
  "filetype_lithiumcategory": "Lithium 類別",
  "lithiumcommunity": "Lithium 社區",
  "filetype_lithiumcommunity": "Lithium 社區",
  "people": "用戶",
  "objecttype_people": "用戶",
  "message": "訊息",
  "objecttype_message": "訊息",
  "feed": "RSS 訂閱",
  "objecttype_feed": "RSS 訂閱",
  "thread": "執行緒",
  "objecttype_thread": "執行緒",
  "file": "文件",
  "objecttype_file": "文件",
  "board": "寫字板",
  "objecttype_board": "寫字板",
  "category": "類別",
  "objecttype_category": "類別",
  "account": "帳戶",
  "objecttype_account": "帳戶",
  "annotation": "注解",
  "objecttype_annotation": "注解",
  "campaign": "活動",
  "objecttype_campaign": "活動",
  "case": "實例",
  "objecttype_case": "實例",
  "contact": "聯繫方式",
  "objecttype_contact": "聯繫方式",
  "contract": "聯繫方式",
  "objecttype_contract": "聯繫方式",
  "event": "公開活動",
  "objecttype_event": "公開活動",
  "email": "Email",
  "objecttype_email": "Email",
  "goal": "目標",
  "objecttype_goal": "目標",
  "objecttype_incident": "實例",
  "invoice": "裝貨清單",
  "objecttype_invoice": "裝貨清單",
  "lead": "導線",
  "objecttype_lead": "導線",
  "list": "列表",
  "objecttype_list": "市場行銷列表",
  "solution": "解決方案",
  "objecttype_solution": "解決方案",
  "task": "任務",
  "objecttype_task": "任務",
  "user": "用戶",
  "objecttype_user": "用戶",
  "attachment": "附件",
  "objecttype_attachment": "附件",
  "casecomment": "案例評論",
  "objecttype_casecomment": "案例評論",
  "opportunity": "機會",
  "objecttype_opportunity": "機會",
  "opportunityproduct": "評估產品機會",
  "objecttype_opportunityproduct": "評估產品機會",
  "feeditem": "Chatter",
  "objecttype_feeditem": "Chatter",
  "feedcomment": "Chatter",
  "objecttype_feedcomment": "Chatter",
  "note": "注解",
  "objecttype_note": "注解",
  "product": "產品",
  "objecttype_product": "產品",
  "partner": "合夥人",
  "objecttype_partner": "合夥人",
  "queueitem": "佇列項",
  "objecttype_queueitem": "佇列項",
  "quote": "報價",
  "objecttype_quote": "報價",
  "salesliterature": "銷售說明書",
  "objecttype_salesliterature": "銷售說明書",
  "salesorder": "銷售定單",
  "objecttype_salesorder": "銷售定單",
  "service": "服務",
  "objecttype_service": "服務",
  "socialprofile": "社會形象",
  "objecttype_socialprofile": "社會形象",
  "kbdocumentation": "檔編制",
  "objecttype_kbdocumentation": "檔編制",
  "kbtechnicalarticle": "檔編制",
  "objecttype_kbtechnicalarticle": "檔編制",
  "kbsolution": "解決方案",
  "objecttype_kbsolution": "解決方案",
  "kbknowledgearticle": "知識文章",
  "objecttype_kbknowledgearticle": "知識文章",
  "kbattachment": "附件",
  "objecttype_kbattachment": "附件",
  "kbarticle": "文章",
  "objecttype_kbarticle": "文章",
  "kbarticlecomment": "文章評論",
  "objecttype_kbarticlecomment": "文章評論",
  "knowledgearticle": "知識文章",
  "objecttype_knowledgearticle": "知識文章",
  "topic": "題目",
  "objecttype_topic": "題目",
  "dashboard": "儀錶板",
  "objecttype_dashboard": "儀錶板",
  "contentversion": "文檔",
  "objecttype_contentversion": "文檔",
  "collaborationgroup": "協作組",
  "objecttype_collaborationgroup": "協作組",
  "spportal": "入口",
  "filetype_spportal": "入口",
  "spsite": "位置",
  "filetype_spsite": "位置",
  "spuserprofile": "SharePoint用戶",
  "filetype_spuserprofile": "SharePoint用戶",
  "sparea": "區域",
  "filetype_sparea": "區域",
  "spannouncement": "公告",
  "filetype_spannouncement": "公告",
  "spannouncementlist": "公告",
  "filetype_spannouncementlist": "公告",
  "spcontact": "聯繫方式",
  "filetype_spcontact": "聯繫方式",
  "spcontactlist": "聯繫方式",
  "filetype_spcontactlist": "聯繫方式",
  "spcustomlist": "自訂清單",
  "filetype_spcustomlist": "自訂清單",
  "spdiscussionboard": "討論板",
  "filetype_spdiscussionboard": "討論板",
  "spdiscussionboardlist": "討論板",
  "filetype_spdiscussionboardlist": "討論板",
  "spdocumentlibrarylist": "文件庫",
  "filetype_spdocumentlibrarylist": "文件庫",
  "spevent": "公開活動",
  "filetype_spevent": "公開活動",
  "speventlist": "公開活動",
  "filetype_speventlist": "公開活動",
  "spformlibrarylist": "表格庫",
  "filetype_spformlibrarylist": "表格庫",
  "spissue": "期號",
  "filetype_spissue": "期號",
  "spissuelist": "期號",
  "filetype_spissuelist": "期號",
  "splink": "鏈接",
  "filetype_splink": "鏈接",
  "splinklist": "鏈接",
  "filetype_splinklist": "鏈接",
  "sppicturelibrarylist": "圖片庫",
  "filetype_sppicturelibrarylist": "圖片庫",
  "spsurvey": "調查",
  "filetype_spsurvey": "調查",
  "spsurveylist": "調查",
  "filetype_spsurveylist": "調查",
  "sptask": "任務",
  "filetype_sptask": "任務",
  "sptasklist": "任務",
  "filetype_sptasklist": "任務",
  "spagenda": "議程表",
  "filetype_spagenda": "議程表",
  "spagendalist": "議程表",
  "filetype_spagendalist": "議程表",
  "spattendee": "與會者",
  "filetype_spattendee": "與會者",
  "spattendeelist": "與會者",
  "filetype_spattendeelist": "與會者",
  "spcustomgridlist": "自訂網格",
  "filetype_spcustomgridlist": "自訂網格",
  "spdecision": "決策",
  "filetype_spdecision": "決策",
  "spdecisionlist": "決策",
  "filetype_spdecisionlist": "決策",
  "spobjective": "目標",
  "filetype_spobjective": "目標",
  "spobjectivelist": "目標",
  "filetype_spobjectivelist": "目標",
  "sptextbox": "文字方塊",
  "filetype_sptextbox": "文字方塊",
  "sptextboxlist": "文字方塊清單",
  "filetype_sptextboxlist": "文字方塊清單",
  "spthingstobring": "要帶的物品",
  "filetype_spthingstobring": "要帶的物品",
  "spthingstobringlist": "要帶的物品",
  "filetype_spthingstobringlist": "要帶的物品",
  "sparealisting": "區域登記",
  "filetype_sparealisting": "區域登記",
  "spmeetingserie": "會議序列",
  "filetype_spmeetingserie": "會議序列",
  "spmeetingserielist": "會議序列列表",
  "filetype_spmeetingserielist": "會議序列列表",
  "spsitedirectory": "網站目錄項",
  "filetype_spsitedirectory": "網站目錄項",
  "spsitedirectorylist": "網站目錄",
  "filetype_spsitedirectorylist": "網站目錄",
  "spdatasource": "資料來源",
  "filetype_spdatasource": "資料來源",
  "spdatasourcelist": "資料來源清單",
  "filetype_spdatasourcelist": "資料來源清單",
  "splisttemplatecataloglist": "清單範本庫",
  "filetype_splisttemplatecataloglist": "清單範本庫",
  "spwebpartcataloglist": "WebPart庫",
  "filetype_spwebpartcataloglist": "WebPart庫",
  "spwebtemplatecataloglist": "网站範本庫",
  "filetype_spwebtemplatecataloglist": "网站範本庫",
  "spworkspacepagelist": "工作區頁面",
  "filetype_spworkspacepagelist": "工作區頁面",
  "spunknownlist": "自訂列表",
  "filetype_spunknownlist": "自訂列表",
  "spadministratortask": "管理員任務",
  "filetype_spadministratortask": "管理員任務",
  "spadministratortasklist": "管理員任務",
  "filetype_spadministratortasklist": "管理員任務",
  "spareadocumentlibrarylist": "區域文件庫",
  "filetype_spareadocumentlibrarylist": "區域文件庫",
  "spblogcategory": "博客分類",
  "filetype_spblogcategory": "博客分類",
  "spblogcategorylist": "博客分類",
  "filetype_spblogcategorylist": "博客分類",
  "spblogcomment": "博客評論",
  "filetype_spblogcomment": "博客評論",
  "spblogcommentlist": "博客評論",
  "filetype_spblogcommentlist": "博客評論",
  "spblogpost": "博客帖子",
  "filetype_spblogpost": "博客帖子",
  "spblogpostlist": "博客帖子",
  "filetype_spblogpostlist": "博客帖子",
  "spdataconnectionlibrarylist": "資料連接庫",
  "filetype_spdataconnectionlibrarylist": "資料連接庫",
  "spdistributiongroup": "流通組織",
  "filetype_spdistributiongroup": "流通組織",
  "spdistributiongrouplist": "流通組織",
  "filetype_spdistributiongrouplist": "流通組織",
  "spipfslist": "InfoPath表單伺服器",
  "filetype_spipfslist": "InfoPath表單伺服器",
  "spkeyperformanceindicator": "關鍵績效指標",
  "filetype_spkeyperformanceindicator": "關鍵績效指標",
  "spkeyperformanceindicatorlist": "關鍵績效指標",
  "filetype_spkeyperformanceindicatorlist": "關鍵績效指標",
  "splanguagesandtranslator": "语言和譯員",
  "filetype_splanguagesandtranslator": "语言和譯員",
  "splanguagesandtranslatorlist": "语言和譯員",
  "filetype_splanguagesandtranslatorlist": "语言和譯員",
  "spmasterpagescataloglist": "母版頁樣式庫",
  "filetype_spmasterpagescataloglist": "母版頁樣式庫",
  "spnocodeworkflowlibrarylist": "無代碼工作流庫",
  "filetype_spnocodeworkflowlibrarylist": "無代碼工作流庫",
  "spprojecttask": "項目任務",
  "filetype_spprojecttask": "項目任務",
  "spprojecttasklist": "項目任務",
  "filetype_spprojecttasklist": "項目任務",
  "sppublishingpageslibrarylist": "頁面庫",
  "filetype_sppublishingpageslibrarylist": "頁面庫",
  "spreportdocumentlibrarylist": "報告文件庫",
  "filetype_spreportdocumentlibrarylist": "報告文件庫",
  "spreportlibrarylist": "報告庫",
  "filetype_spreportlibrarylist": "報告庫",
  "spslidelibrarylist": "幻燈片庫",
  "filetype_spslidelibrarylist": "幻燈片庫",
  "sptab": "標籤",
  "filetype_sptab": "標籤",
  "sptablist": "標籤列表",
  "filetype_sptablist": "標籤列表",
  "sptranslationmanagementlibrarylist": "翻譯管理庫",
  "filetype_sptranslationmanagementlibrarylist": "翻譯管理庫",
  "spuserinformation": "使用者資訊",
  "filetype_spuserinformation": "使用者資訊",
  "spuserinformationlist": "使用者資訊清單",
  "filetype_spuserinformationlist": "使用者資訊清單",
  "spwikipagelibrarylist": "維琪頁面庫",
  "filetype_spwikipagelibrarylist": "維琪頁面庫",
  "spworkflowhistory": "工作流歷史",
  "filetype_spworkflowhistory": "工作流歷史",
  "spworkflowhistorylist": "工作流歷史列表",
  "filetype_spworkflowhistorylist": "工作流歷史列表",
  "spworkflowprocess": "自訂工作流程",
  "filetype_spworkflowprocess": "自訂工作流程",
  "spworkflowprocesslist": "自訂工作流程",
  "filetype_spworkflowprocesslist": "自訂工作流程",
  "sppublishingimageslibrarylist": "發行圖像庫",
  "filetype_sppublishingimageslibrarylist": "發行圖像庫",
  "spcirculation": "發行量",
  "filetype_spcirculation": "發行量",
  "spcirculationlist": "發行量",
  "filetype_spcirculationlist": "發行量",
  "spdashboardslibrarylist": "儀錶板庫",
  "filetype_spdashboardslibrarylist": "儀錶板庫",
  "spdataconnectionforperformancepointlibrarylist": "PerformancePoint 數據連接庫",
  "filetype_spdataconnectionforperformancepointlibrarylist": "PerformancePoint 數據連接庫",
  "sphealthreport": "健康報導",
  "filetype_sphealthreport": "健康報導",
  "sphealthreportlist": "健康報導",
  "filetype_sphealthreportlist": "健康報導",
  "sphealthrule": "保健規律",
  "filetype_sphealthrule": "保健規律",
  "sphealthrulelist": "保健規律",
  "filetype_sphealthrulelist": "保健規律",
  "spimedictionary": "IME詞典",
  "filetype_spimedictionary": "IME詞典",
  "spimedictionarylist": "IME詞典",
  "filetype_spimedictionarylist": "IME詞典",
  "spperformancepointcontent": "PerformancePoint 目錄",
  "filetype_spperformancepointcontent": "PerformancePoint 目錄",
  "spperformancepointcontentlist": "PerformancePoint 目錄",
  "filetype_spperformancepointcontentlist": "PerformancePoint 目錄",
  "spphonecallmemo": "電話備忘錄",
  "filetype_spphonecallmemo": "電話備忘錄",
  "spphonecallmemolist": "電話備忘錄",
  "filetype_spphonecallmemolist": "電話備忘錄",
  "sprecordlibrarylist": "唱片貯藏室",
  "filetype_sprecordlibrarylist": "唱片貯藏室",
  "spresource": "資源",
  "filetype_spresource": "資源",
  "spresourcelist": "資源",
  "filetype_spresourcelist": "資源",
  "spprocessdiagramslibrarylist": "流程圖庫",
  "filetype_spprocessdiagramslibrarylist": "流程圖庫",
  "spsitethemeslibrarylist": "網站主題庫",
  "filetype_spsitethemeslibrarylist": "網站主題庫",
  "spsolutionslibrarylist": "解決方案庫",
  "filetype_spsolutionslibrarylist": "解決方案庫",
  "spwfpublibrarylist": "WFPUB 庫",
  "filetype_spwfpublibrarylist": "WFPUB 庫",
  "spwhereabout": "所在之處",
  "filetype_spwhereabout": "所在之處",
  "spwhereaboutlist": "所在之處",
  "filetype_spwhereaboutlist": "所在之處",
  "spdocumentlink": "連結到文檔",
  "filetype_spdocumentlink": "連結到文檔",
  "spdocumentset": "文檔集",
  "filetype_spdocumentset": "文檔集",
  "spmicrofeedpost": "Microfeed 帖子",
  "filetype_spmicrofeedpost": "Microfeed 帖子",
  "spmicrofeedlist": "Microfeed",
  "filetype_spmicrofeedlist": "Microfeed",
  "splistfolder": "列表文件夾",
  "filetype_splistfolder": "列表文件夾",
  "Unknown": "未知",
  "And": "與",
  "Authenticating": "驗證 {0}...",
  "Clear": "清除 {0}",
  "CompleteQuery": "完整查詢",
  "Exclude": "排除 {0}",
  "EnterTag": "添加標記",
  "Next": "下一頁",
  "Last": "最後一頁",
  "Link": "連結",
  "Or": "或",
  "Previous": "上一頁",
  "QueryDidntMatchAnyDocuments": "您的查詢與任何文件都不匹配。",
  "QueryException": "您的查詢存在錯誤： {0}。",
  "Me": "我",
  "Remove": "刪除",
  "Search": "搜尋",
  "SearchFor": "搜尋 {0}",
  "ShareQuery": "共用查詢",
  "Preferences": "喜好設定",
  "LinkOpeningSettings": "連結打開設定",
  "Reauthenticate": "重新驗證 {0}",
  "ResultsFilteringExpression": "結果篩選運算式",
  "FiltersInYourPreferences": "喜好設定中的篩選條件",
  "Create": "創建",
  "SearchIn": "在 {0} 中搜尋",
  "Seconds": "用時 {0} 秒",
  "ShowingResultsOf": "結果數 {0}<pl>-{1}</pl>，總數 {2}",
  "ShowingResultsOfWithQuery": "结果数 {0}<pl>-{1}</pl>，总数 {2}, 搜索 {3}",
  "SwitchTo": "切換到 {0}",
  "Unexclude": "不排除 {0}",
  "ClearAllFilters": "清除所有篩選條件",
  "SkipLogin": "跳過登入",
  "LoginInProgress": "正在登入，請稍候...",
  "Login": "登入",
  "GetStarted": "開始體驗",
  "More": "更多",
  "NMore": "{0} 更多...",
  "Less": "更少",
  "Settings": "設定",
  "Score": "得分",
  "ScoreDescription": "得分是根據出現次數和在結果集中的位置計算得來。",
  "Occurrences": "出現次數",
  "OccurrencesDescription": "按出現次數排序，出現次數最高的值排在首位。",
  "Label": "標籤",
  "Of": "第...個，共...個",
  "LabelDescription": "對欄位值按字母順序排序。",
  "Value": "值",
  "ValueDescription": "按第一個計算得出的欄位的值排序",
  "AlphaAscending": "值遞增排序",
  "AlphaDescending": "值遞減排序",
  "ChiSquare": "卡方值",
  "Nosort": "無排序",
  "NosortDescription": "不排序值。值將返回隨機排序。",
  "RelativeFrequency": "相對頻率",
  "RelativeFrequencyDescription": "基於值的相對頻率排序。較不常見的值將出現在較高位置。",
  "DateDistribution": "日期分佈",
  "Custom": "自訂",
  "CustomDescription": "基於自訂順序排序",
  "ComputedField": "計算得出的欄位",
  "Ascending": "遞增",
  "Descending": "遞減",
  "noResultFor": "沒有找到與 {0} 相關的結果",
  "autoCorrectedQueryTo": "查詢自動校正為 {0}",
  "didYouMean": "您要找的是不是： {0}",
  "SuggestedResults": "建議的結果",
  "SuggestedQueries": "建議的查詢",
  "MostRelevantItems": "最相關的項：",
  "AllItems": "所有項：",
  "ShowLess": "顯示較少的值",
  "ShowMore": "顯示較多的值",
  "HideFacet": "隱藏快捷控制介面",
  "ShowFacet": "顯示快捷控制介面",
  "AndOthers": "以及 {0} 個其他項",
  "Others": "{0} 個其他項",
  "MostRelevantPosts": "最相關的公佈內容：",
  "CompleteThread": "完整的主題：",
  "ShowCompleteThread": "顯示完整的主題",
  "ShowOnlyTopMatchingPosts": "僅顯示最匹配的公佈內容",
  "MostRelevantReplies": "最相關的回復：",
  "AllConversation": "所有對話：",
  "ShowAllConversation": "顯示所有對話",
  "ShowAllReplies": "顯示所有回復",
  "ShowOnlyMostRelevantReplies": "僅顯示最相關的回復",
  "Close": "關閉",
  "Open": "打開",
  "OpenInOutlookWhenPossible": "在 Outlook 中打開（如果可能）",
  "AlwaysOpenInNewWindow": "總是在新視窗中打開結果",
  "Quickview": "快速檢視",
  "NoQuickview": "此文檔無法快速瀏覽。",
  "ErrorReport": "錯誤報告",
  "OopsError": "伺服器出現了錯誤。",
  "ProblemPersists": "如果問題仍然存在，請連絡管理員。",
  "GoBack": "返回",
  "Reset": "重設",
  "Retry": "重試",
  "MoreInfo": "更多資訊",
  "Username": "用戶名",
  "Password": "密碼",
  "PostedBy": "公佈者",
  "CannotConnect": "無法連線到該伺服器位址。",
  "BadUserPass": "密碼與用戶名不匹配。",
  "PleaseEnterYourCredentials": "請輸入您的 {0} 認證。",
  "PleaseEnterYourSearchPage": "請輸入您的搜尋網頁 URL",
  "Collapse": "摺疊",
  "Collapsable": "可摺疊",
  "Expand": "展開",
  "Today": "今天",
  "Yesterday": "昨天",
  "Tomorrow": "明天",
  "Duration": "持續時間： {0}",
  "IndexDuration": "索引持續時間： {0}",
  "ProxyDuration": "Proxy 持續時間： {0}",
  "ClientDuration": "用戶端持續時間： {0}",
  "Unavailable": "不可用",
  "Reply": "回復",
  "ReplyAll": "全部回復",
  "Forward": "轉寄",
  "From": "寄件者",
  "Caption": "標題",
  "Expression": "運算式",
  "Tab": "索引標籤",
  "Tabs": "多個索引標籤",
  "EnterExpressionName": "輸入運算式名稱",
  "EnterExpressionToFilterWith": "輸入用於篩選結果的運算式",
  "SelectTab": "選擇索引標籤",
  "SelectAll": "全選",
  "PageUrl": "搜尋網頁 URL",
  "ErrorSavingToDevice": "在將資訊保存到您的設備時出錯",
  "ErrorReadingFromDevice": "在從您的設備讀取資訊時出錯",
  "AppIntro": "諮詢能夠回答您有關 Coveo 的問題的產品專家，並幫助您確定哪個 Coveo 解決方案適合您。或者，嘗試現場示範！",
  "TryDemo": "嘗試示範",
  "ContactUs": "連絡我們",
  "NewToCoveo": "Coveo 的新使用者？",
  "LetUsHelpGetStarted": "讓我們幫助您開始體驗",
  "LikesThis": "{0} 喜歡此解決方案。",
  "CannotConnectSearchPage": "無法連線到您的搜尋網頁",
  "AreYouSureDeleteFilter": "您是否確定要刪除採用 {1} 運算式的篩選條件 {0}",
  "OnlineHelp": "線上說明",
  "Done": "完成",
  "SaveFacetState": "保存此快捷控制介面狀態",
  "ClearFacetState": "清除快捷控制介面狀態",
  "DisplayingTheOnlyMessage": "僅顯示此對話中的消息",
  "NoNetworkConnection": "沒有網路連線",
  "UnknownConnection": "未知的連線",
  "EthernetConnection": "乙太網路連線",
  "WiFi": "WiFi 連線",
  "CELL": "行動電話連線",
  "CELL_2G": "行動電話 2G 連線",
  "CELL_3G": "行動電話 3G 連線",
  "CELL_4G": "行動電話 4G 連線",
  "Relevance": "關聯",
  "Date": "日期",
  "Amount": "數量",
  "QueryExceptionNoException": "沒有例外",
  "QueryExceptionInvalidSyntax": "無效語法",
  "QueryExceptionInvalidCustomField": "無效自訂欄位",
  "QueryExceptionInvalidDate": "無效日期",
  "QueryExceptionInvalidExactPhrase": "無效精確短語",
  "QueryExceptionInvalidDateOp": "無效日期運算子",
  "QueryExceptionInvalidNear": "無效 NEAR 運算子",
  "QueryExceptionInvalidWeightedNear": "無效加權 NEAR",
  "QueryExceptionInvalidTerm": "無效條件",
  "QueryExceptionTooManyTerms": "太多條件",
  "QueryExceptionWildcardTooGeneral": "萬用字元太常見",
  "QueryExceptionInvalidSortField": "無效排序欄位",
  "QueryExceptionInvalidSmallStringOp": "無效小字串運算子",
  "QueryExceptionRequestedResultsMax": "要求的最大結果數",
  "QueryExceptionAggregatedMirrorDead": "遠端聚合鏡像處於離線狀態",
  "QueryExceptionAggregatedMirrorQueryTimeOut": "遠端聚合鏡像查詢超時",
  "QueryExceptionAggregatedMirrorInvalidBuildNumber": "遠程聚合鏡像無效版本號",
  "QueryExceptionAggregatedMirrorCannotConnect": "遠端聚合鏡像無法連線",
  "QueryExceptionNotEnoughLeadingCharsWildcard": "主字元萬用字元不足",
  "QueryExceptionSecurityInverterNotFound": "未找到安全變換器",
  "QueryExceptionSecurityInverterAccessDenied": "安全變換器存取被拒絕",
  "QueryExceptionAggregatedMirrorCannotImpersonate": "遠端聚合鏡像無法模擬",
  "QueryExceptionUnexpected": "意外",
  "QueryExceptionAccessDenied": "存取被拒絕",
  "QueryExceptionSuperUserTokenInvalid": "進階使用者權杖無效",
  "QueryExceptionSuperUserTokenExpired": "進階使用者權杖已過期",
  "QueryExceptionLicenseQueriesExpired": "查詢授權已過期",
  "QueryExceptionLicenseSuperUserTokenNotSupported": "授權進階使用者權杖不支援",
  "QueryExceptionInvalidSession": "無效會話",
  "QueryExceptionInvalidDocument": "無效文件",
  "QueryExceptionSearchDisabled": "搜尋被禁用",
  "FileType": "檔案類型",
  "ShowAttachment": "顯示附件",
  "OnFeed": "有關 {0} 的輸入。",
  "Author": "作者",
  "NoTitle": "無標題",
  "CurrentSelections": "當前選擇",
  "AllContent": "所有內容",
  "CancelLastAction": "取消最後一個動作",
  "SearchTips": "搜尋提示",
  "CheckSpelling": "檢查關鍵字的拼寫。",
  "TryUsingFewerKeywords": "嘗試使用更少、更常用或不同的關鍵字。",
  "SelectFewerFilters": "選擇較少的篩選條件以擴大您的搜尋範圍。",
  "Document": "文件",
  "Time": "時間",
  "StartDate": "開始日期",
  "StartTime": "啟動時間",
  "DurationTitle": "持續時間",
  "UserQuery": "用戶查詢",
  "ShowUserActions": "顯示用戶操作",
  "NoData": "無可用資料",
  "EventType": "事件類型",
  "GoToFullSearch": "全面搜尋",
  "GoToEdition": "定制儀錶板",
  "RemoveContext": "刪除上下文",
  "BoxAttachToCase": "加入實例",
  "AttachToCase": "加入實例",
  "Attach": "附件",
  "Attached": "附上",
  "Detach": "分離",
  "Details": "詳細說明",
  "AdditionalFilters": "額外的篩選器",
  "SelectNonContextualSearch": "於目前記錄中刪除上下文以擴大搜尋範圍",
  "CopyPasteToSupport": "將此消息複製粘貼到柯維歐支援小組以獲取更多資訊。",
  "FollowQueryDescription": "提醒我對此查詢的搜尋結果的更改。",
  "SearchAlerts_Panel": "管理通告",
  "SearchAlerts_PanelDescription": "查看並管理您的搜尋通告",
  "SearchAlerts_PanelNoSearchAlerts": "您沒有訂閱",
  "SearchAlerts_Fail": "搜尋通告服務目前無法使用.",
  "SearchAlerts_Type": "類型",
  "SearchAlerts_Content": "內容",
  "SearchAlerts_Actions": "動作",
  "EmptyQuery": "<清空>",
  "SearchAlerts_Type_followQuery": "查詢",
  "SearchAlerts_Type_followDocument": "項",
  "SearchAlerts_unFollowing": "停止關注",
  "SearchAlerts_follow": "按照",
  "SearchAlerts_followed": "緊隨",
  "SearchAlerts_followQuery": "按照查詢",
  "Subscription_StopFollowingQuery": "停止以下查詢",
  "SearchAlerts_Frequency": "什麼時間",
  "SubscriptionsManageSubscriptions": "管理通告",
  "SubscriptionsMessageFollowQuery": "當查詢<b> {0} </ b>恢復新專案或更動專案時，您將收到提示。",
  "SubscriptionsMessageFollow": "您會收到有關專案<b> {0} </ b>的更改的提醒。",
  "Expiration": "期滿",
  "Monthly": "每月一次",
  "Daily": "每日一次",
  "Monday": "星期一",
  "Tuesday": "星期二",
  "Wednesday": "星期三",
  "Thursday": "週四",
  "Friday": "星期五",
  "Saturday": "星期六",
  "Sunday": "周日",
  "NextDay": "下一頁{0}",
  "LastDay": "最後一頁{0}",
  "StartTypingCaseForSuggestions": "描述你的問題，參見可能的解決方案",
  "ExportToExcel": "匯出到 Excel",
  "ExportToExcelDescription": "將搜尋結果匯出到 Excel",
  "CaseCreationNoResults": "沒有找到推薦的解決方案",
  "SortBy": "排序依據",
  "BoxCreateArticle": "創建文章",
  "Facets": "快捷控制介面",
  "AdvancedSearch": "高級搜尋",
  "Keywords": "關鍵字",
  "AllTheseWords": "所有這些詞語",
  "ExactPhrase": "這個確切詞",
  "AnyOfTheseWords": "所有這些詞語",
  "NoneOfTheseWords": "無這些詞語",
  "Anytime": "任何時間",
  "InTheLast": "最後",
  "Days": "天數",
  "Months": "月份",
  "Month": "月份",
  "Year": "年度",
  "Between": "介於",
  "Language": "語言設定",
  "Size": "規格",
  "AtLeast": "最低限度",
  "AtMost": "最高限度",
  "Contains": "含有",
  "DoesNotContain": "不含",
  "Matches": "匹配",
  "Bytes": "位元組",
  "card": "卡片",
  "table": "表格",
  "ResultLinks": "結果頁面的連結",
  "EnableQuerySyntax": "啟用查詢語法",
  "On": "打開",
  "Off": "關閉",
  "Automatic": "自動",
  "ResultsPerPage": "每頁的結果數",
  "PreviousMonth": "前一個月",
  "NextMonth": "下個月",
  "Title": "題目",
}
  var locales = String["locales"] || (String["locales"] = {});
  locales["zh-TW"] = merge(locales["zh-TW"], dict);
  String["toLocaleString"].call(this, { "zh-TW": dict });
  String["locale"] = "zh-TW";
  String["defaultLocale"] = "en";
  Globalize.culture("zh-TW")})();
if(!window.Coveo){window.Coveo = {};}
Coveo.setLanguageAfterPageLoaded = function() {
var merge = function(obj1, obj2) {
  var obj3 = {};
  for(var attrname in obj1){obj3[attrname] = obj1[attrname]; }
  for(var attrname in obj2){obj3[attrname] = obj2[attrname]; }
  return obj3;
}

var dict = {
  "box user": "用戶",
  "filetype_box user": "用戶",
  "html": "HTML文件",
  "filetype_html": "HTML文件",
  "wiki": "WiKi",
  "filetype_wiki": "WiKi",
  "webscraperwebpage": "網頁",
  "filetype_webscraperwebpage": "網頁",
  "image": "影像",
  "filetype_image": "影像",
  "folder": "資料夾",
  "filetype_folder": "資料夾",
  "txt": "文本",
  "filetype_txt": "文本",
  "zip": "Zip文件",
  "filetype_zip": "Zip文件",
  "olefile": "OLE文件",
  "filetype_olefile": "OLE文件",
  "gmailmessage": "Gmail訊息",
  "filetype_gmailmessage": "Gmail訊息",
  "pdf": "PDF文件",
  "filetype_pdf": "PDF文件",
  "swf": "Flash文件",
  "filetype_swf": "Flash文件",
  "xml": "XML文件",
  "filetype_xml": "XML文件",
  "vsd": "Visio",
  "filetype_vsd": "Visio",
  "svg": "SVG",
  "filetype_svg": "SVG",
  "svm": "Open Office",
  "filetype_svm": "Open Office",
  "rssitem": "RSS 訂閱",
  "filetype_rssitem": "RSS 訂閱",
  "doc": "文檔",
  "filetype_doc": "文檔",
  "docx": "Microsoft Word 文檔",
  "filetype_docx": "Microsoft Word 文檔",
  "xls": "試算表文文件",
  "filetype_xls": "試算表文文件",
  "ppt": "演示視窗",
  "filetype_ppt": "演示視窗",
  "video": "視頻",
  "filetype_video": "視頻",
  "saleforceitem": "Salesforce",
  "filetype_saleforceitem": "Salesforce",
  "dynamicscrmitem": "Dynamics CRM",
  "filetype_dynamicscrmitem": "Dynamics CRM",
  "salesforceitem": "Salesforce",
  "filetype_salesforceitem": "Salesforce",
  "odt": "打開文本文檔",
  "filetype_odt": "打開文本文檔",
  "lithiummessage": "Lithium 訊息",
  "filetype_lithiummessage": "Lithium 訊息",
  "lithiumthread": "Lithium 執行緒",
  "filetype_lithiumthread": "Lithium 執行緒",
  "lithiumboard": "Lithium 寫字板",
  "filetype_lithiumboard": "Lithium 寫字板",
  "lithiumcategory": "Lithium 類別",
  "filetype_lithiumcategory": "Lithium 類別",
  "lithiumcommunity": "Lithium 社區",
  "filetype_lithiumcommunity": "Lithium 社區",
  "people": "用戶",
  "objecttype_people": "用戶",
  "message": "訊息",
  "objecttype_message": "訊息",
  "feed": "RSS 訂閱",
  "objecttype_feed": "RSS 訂閱",
  "thread": "執行緒",
  "objecttype_thread": "執行緒",
  "file": "文件",
  "objecttype_file": "文件",
  "board": "寫字板",
  "objecttype_board": "寫字板",
  "category": "類別",
  "objecttype_category": "類別",
  "account": "帳戶",
  "objecttype_account": "帳戶",
  "annotation": "注解",
  "objecttype_annotation": "注解",
  "campaign": "活動",
  "objecttype_campaign": "活動",
  "case": "實例",
  "objecttype_case": "實例",
  "contact": "聯繫方式",
  "objecttype_contact": "聯繫方式",
  "contract": "聯繫方式",
  "objecttype_contract": "聯繫方式",
  "event": "公開活動",
  "objecttype_event": "公開活動",
  "email": "Email",
  "objecttype_email": "Email",
  "goal": "目標",
  "objecttype_goal": "目標",
  "objecttype_incident": "實例",
  "invoice": "裝貨清單",
  "objecttype_invoice": "裝貨清單",
  "lead": "導線",
  "objecttype_lead": "導線",
  "list": "列表",
  "objecttype_list": "市場行銷列表",
  "solution": "解決方案",
  "objecttype_solution": "解決方案",
  "task": "任務",
  "objecttype_task": "任務",
  "user": "用戶",
  "objecttype_user": "用戶",
  "attachment": "附件",
  "objecttype_attachment": "附件",
  "casecomment": "案例評論",
  "objecttype_casecomment": "案例評論",
  "opportunity": "機會",
  "objecttype_opportunity": "機會",
  "opportunityproduct": "評估產品機會",
  "objecttype_opportunityproduct": "評估產品機會",
  "feeditem": "Chatter",
  "objecttype_feeditem": "Chatter",
  "feedcomment": "Chatter",
  "objecttype_feedcomment": "Chatter",
  "note": "注解",
  "objecttype_note": "注解",
  "product": "產品",
  "objecttype_product": "產品",
  "partner": "合夥人",
  "objecttype_partner": "合夥人",
  "queueitem": "佇列項",
  "objecttype_queueitem": "佇列項",
  "quote": "報價",
  "objecttype_quote": "報價",
  "salesliterature": "銷售說明書",
  "objecttype_salesliterature": "銷售說明書",
  "salesorder": "銷售定單",
  "objecttype_salesorder": "銷售定單",
  "service": "服務",
  "objecttype_service": "服務",
  "socialprofile": "社會形象",
  "objecttype_socialprofile": "社會形象",
  "kbdocumentation": "檔編制",
  "objecttype_kbdocumentation": "檔編制",
  "kbtechnicalarticle": "檔編制",
  "objecttype_kbtechnicalarticle": "檔編制",
  "kbsolution": "解決方案",
  "objecttype_kbsolution": "解決方案",
  "kbknowledgearticle": "知識文章",
  "objecttype_kbknowledgearticle": "知識文章",
  "kbattachment": "附件",
  "objecttype_kbattachment": "附件",
  "kbarticle": "文章",
  "objecttype_kbarticle": "文章",
  "kbarticlecomment": "文章評論",
  "objecttype_kbarticlecomment": "文章評論",
  "knowledgearticle": "知識文章",
  "objecttype_knowledgearticle": "知識文章",
  "topic": "題目",
  "objecttype_topic": "題目",
  "dashboard": "儀錶板",
  "objecttype_dashboard": "儀錶板",
  "contentversion": "文檔",
  "objecttype_contentversion": "文檔",
  "collaborationgroup": "協作組",
  "objecttype_collaborationgroup": "協作組",
  "spportal": "入口",
  "filetype_spportal": "入口",
  "spsite": "位置",
  "filetype_spsite": "位置",
  "spuserprofile": "SharePoint用戶",
  "filetype_spuserprofile": "SharePoint用戶",
  "sparea": "區域",
  "filetype_sparea": "區域",
  "spannouncement": "公告",
  "filetype_spannouncement": "公告",
  "spannouncementlist": "公告",
  "filetype_spannouncementlist": "公告",
  "spcontact": "聯繫方式",
  "filetype_spcontact": "聯繫方式",
  "spcontactlist": "聯繫方式",
  "filetype_spcontactlist": "聯繫方式",
  "spcustomlist": "自訂清單",
  "filetype_spcustomlist": "自訂清單",
  "spdiscussionboard": "討論板",
  "filetype_spdiscussionboard": "討論板",
  "spdiscussionboardlist": "討論板",
  "filetype_spdiscussionboardlist": "討論板",
  "spdocumentlibrarylist": "文件庫",
  "filetype_spdocumentlibrarylist": "文件庫",
  "spevent": "公開活動",
  "filetype_spevent": "公開活動",
  "speventlist": "公開活動",
  "filetype_speventlist": "公開活動",
  "spformlibrarylist": "表格庫",
  "filetype_spformlibrarylist": "表格庫",
  "spissue": "期號",
  "filetype_spissue": "期號",
  "spissuelist": "期號",
  "filetype_spissuelist": "期號",
  "splink": "鏈接",
  "filetype_splink": "鏈接",
  "splinklist": "鏈接",
  "filetype_splinklist": "鏈接",
  "sppicturelibrarylist": "圖片庫",
  "filetype_sppicturelibrarylist": "圖片庫",
  "spsurvey": "調查",
  "filetype_spsurvey": "調查",
  "spsurveylist": "調查",
  "filetype_spsurveylist": "調查",
  "sptask": "任務",
  "filetype_sptask": "任務",
  "sptasklist": "任務",
  "filetype_sptasklist": "任務",
  "spagenda": "議程表",
  "filetype_spagenda": "議程表",
  "spagendalist": "議程表",
  "filetype_spagendalist": "議程表",
  "spattendee": "與會者",
  "filetype_spattendee": "與會者",
  "spattendeelist": "與會者",
  "filetype_spattendeelist": "與會者",
  "spcustomgridlist": "自訂網格",
  "filetype_spcustomgridlist": "自訂網格",
  "spdecision": "決策",
  "filetype_spdecision": "決策",
  "spdecisionlist": "決策",
  "filetype_spdecisionlist": "決策",
  "spobjective": "目標",
  "filetype_spobjective": "目標",
  "spobjectivelist": "目標",
  "filetype_spobjectivelist": "目標",
  "sptextbox": "文字方塊",
  "filetype_sptextbox": "文字方塊",
  "sptextboxlist": "文字方塊清單",
  "filetype_sptextboxlist": "文字方塊清單",
  "spthingstobring": "要帶的物品",
  "filetype_spthingstobring": "要帶的物品",
  "spthingstobringlist": "要帶的物品",
  "filetype_spthingstobringlist": "要帶的物品",
  "sparealisting": "區域登記",
  "filetype_sparealisting": "區域登記",
  "spmeetingserie": "會議序列",
  "filetype_spmeetingserie": "會議序列",
  "spmeetingserielist": "會議序列列表",
  "filetype_spmeetingserielist": "會議序列列表",
  "spsitedirectory": "網站目錄項",
  "filetype_spsitedirectory": "網站目錄項",
  "spsitedirectorylist": "網站目錄",
  "filetype_spsitedirectorylist": "網站目錄",
  "spdatasource": "資料來源",
  "filetype_spdatasource": "資料來源",
  "spdatasourcelist": "資料來源清單",
  "filetype_spdatasourcelist": "資料來源清單",
  "splisttemplatecataloglist": "清單範本庫",
  "filetype_splisttemplatecataloglist": "清單範本庫",
  "spwebpartcataloglist": "WebPart庫",
  "filetype_spwebpartcataloglist": "WebPart庫",
  "spwebtemplatecataloglist": "网站範本庫",
  "filetype_spwebtemplatecataloglist": "网站範本庫",
  "spworkspacepagelist": "工作區頁面",
  "filetype_spworkspacepagelist": "工作區頁面",
  "spunknownlist": "自訂列表",
  "filetype_spunknownlist": "自訂列表",
  "spadministratortask": "管理員任務",
  "filetype_spadministratortask": "管理員任務",
  "spadministratortasklist": "管理員任務",
  "filetype_spadministratortasklist": "管理員任務",
  "spareadocumentlibrarylist": "區域文件庫",
  "filetype_spareadocumentlibrarylist": "區域文件庫",
  "spblogcategory": "博客分類",
  "filetype_spblogcategory": "博客分類",
  "spblogcategorylist": "博客分類",
  "filetype_spblogcategorylist": "博客分類",
  "spblogcomment": "博客評論",
  "filetype_spblogcomment": "博客評論",
  "spblogcommentlist": "博客評論",
  "filetype_spblogcommentlist": "博客評論",
  "spblogpost": "博客帖子",
  "filetype_spblogpost": "博客帖子",
  "spblogpostlist": "博客帖子",
  "filetype_spblogpostlist": "博客帖子",
  "spdataconnectionlibrarylist": "資料連接庫",
  "filetype_spdataconnectionlibrarylist": "資料連接庫",
  "spdistributiongroup": "流通組織",
  "filetype_spdistributiongroup": "流通組織",
  "spdistributiongrouplist": "流通組織",
  "filetype_spdistributiongrouplist": "流通組織",
  "spipfslist": "InfoPath表單伺服器",
  "filetype_spipfslist": "InfoPath表單伺服器",
  "spkeyperformanceindicator": "關鍵績效指標",
  "filetype_spkeyperformanceindicator": "關鍵績效指標",
  "spkeyperformanceindicatorlist": "關鍵績效指標",
  "filetype_spkeyperformanceindicatorlist": "關鍵績效指標",
  "splanguagesandtranslator": "语言和譯員",
  "filetype_splanguagesandtranslator": "语言和譯員",
  "splanguagesandtranslatorlist": "语言和譯員",
  "filetype_splanguagesandtranslatorlist": "语言和譯員",
  "spmasterpagescataloglist": "母版頁樣式庫",
  "filetype_spmasterpagescataloglist": "母版頁樣式庫",
  "spnocodeworkflowlibrarylist": "無代碼工作流庫",
  "filetype_spnocodeworkflowlibrarylist": "無代碼工作流庫",
  "spprojecttask": "項目任務",
  "filetype_spprojecttask": "項目任務",
  "spprojecttasklist": "項目任務",
  "filetype_spprojecttasklist": "項目任務",
  "sppublishingpageslibrarylist": "頁面庫",
  "filetype_sppublishingpageslibrarylist": "頁面庫",
  "spreportdocumentlibrarylist": "報告文件庫",
  "filetype_spreportdocumentlibrarylist": "報告文件庫",
  "spreportlibrarylist": "報告庫",
  "filetype_spreportlibrarylist": "報告庫",
  "spslidelibrarylist": "幻燈片庫",
  "filetype_spslidelibrarylist": "幻燈片庫",
  "sptab": "標籤",
  "filetype_sptab": "標籤",
  "sptablist": "標籤列表",
  "filetype_sptablist": "標籤列表",
  "sptranslationmanagementlibrarylist": "翻譯管理庫",
  "filetype_sptranslationmanagementlibrarylist": "翻譯管理庫",
  "spuserinformation": "使用者資訊",
  "filetype_spuserinformation": "使用者資訊",
  "spuserinformationlist": "使用者資訊清單",
  "filetype_spuserinformationlist": "使用者資訊清單",
  "spwikipagelibrarylist": "維琪頁面庫",
  "filetype_spwikipagelibrarylist": "維琪頁面庫",
  "spworkflowhistory": "工作流歷史",
  "filetype_spworkflowhistory": "工作流歷史",
  "spworkflowhistorylist": "工作流歷史列表",
  "filetype_spworkflowhistorylist": "工作流歷史列表",
  "spworkflowprocess": "自訂工作流程",
  "filetype_spworkflowprocess": "自訂工作流程",
  "spworkflowprocesslist": "自訂工作流程",
  "filetype_spworkflowprocesslist": "自訂工作流程",
  "sppublishingimageslibrarylist": "發行圖像庫",
  "filetype_sppublishingimageslibrarylist": "發行圖像庫",
  "spcirculation": "發行量",
  "filetype_spcirculation": "發行量",
  "spcirculationlist": "發行量",
  "filetype_spcirculationlist": "發行量",
  "spdashboardslibrarylist": "儀錶板庫",
  "filetype_spdashboardslibrarylist": "儀錶板庫",
  "spdataconnectionforperformancepointlibrarylist": "PerformancePoint 數據連接庫",
  "filetype_spdataconnectionforperformancepointlibrarylist": "PerformancePoint 數據連接庫",
  "sphealthreport": "健康報導",
  "filetype_sphealthreport": "健康報導",
  "sphealthreportlist": "健康報導",
  "filetype_sphealthreportlist": "健康報導",
  "sphealthrule": "保健規律",
  "filetype_sphealthrule": "保健規律",
  "sphealthrulelist": "保健規律",
  "filetype_sphealthrulelist": "保健規律",
  "spimedictionary": "IME詞典",
  "filetype_spimedictionary": "IME詞典",
  "spimedictionarylist": "IME詞典",
  "filetype_spimedictionarylist": "IME詞典",
  "spperformancepointcontent": "PerformancePoint 目錄",
  "filetype_spperformancepointcontent": "PerformancePoint 目錄",
  "spperformancepointcontentlist": "PerformancePoint 目錄",
  "filetype_spperformancepointcontentlist": "PerformancePoint 目錄",
  "spphonecallmemo": "電話備忘錄",
  "filetype_spphonecallmemo": "電話備忘錄",
  "spphonecallmemolist": "電話備忘錄",
  "filetype_spphonecallmemolist": "電話備忘錄",
  "sprecordlibrarylist": "唱片貯藏室",
  "filetype_sprecordlibrarylist": "唱片貯藏室",
  "spresource": "資源",
  "filetype_spresource": "資源",
  "spresourcelist": "資源",
  "filetype_spresourcelist": "資源",
  "spprocessdiagramslibrarylist": "流程圖庫",
  "filetype_spprocessdiagramslibrarylist": "流程圖庫",
  "spsitethemeslibrarylist": "網站主題庫",
  "filetype_spsitethemeslibrarylist": "網站主題庫",
  "spsolutionslibrarylist": "解決方案庫",
  "filetype_spsolutionslibrarylist": "解決方案庫",
  "spwfpublibrarylist": "WFPUB 庫",
  "filetype_spwfpublibrarylist": "WFPUB 庫",
  "spwhereabout": "所在之處",
  "filetype_spwhereabout": "所在之處",
  "spwhereaboutlist": "所在之處",
  "filetype_spwhereaboutlist": "所在之處",
  "spdocumentlink": "連結到文檔",
  "filetype_spdocumentlink": "連結到文檔",
  "spdocumentset": "文檔集",
  "filetype_spdocumentset": "文檔集",
  "spmicrofeedpost": "Microfeed 帖子",
  "filetype_spmicrofeedpost": "Microfeed 帖子",
  "spmicrofeedlist": "Microfeed",
  "filetype_spmicrofeedlist": "Microfeed",
  "splistfolder": "列表文件夾",
  "filetype_splistfolder": "列表文件夾",
  "Unknown": "未知",
  "And": "與",
  "Authenticating": "驗證 {0}...",
  "Clear": "清除 {0}",
  "CompleteQuery": "完整查詢",
  "Exclude": "排除 {0}",
  "EnterTag": "添加標記",
  "Next": "下一頁",
  "Last": "最後一頁",
  "Link": "連結",
  "Or": "或",
  "Previous": "上一頁",
  "QueryDidntMatchAnyDocuments": "您的查詢與任何文件都不匹配。",
  "QueryException": "您的查詢存在錯誤： {0}。",
  "Me": "我",
  "Remove": "刪除",
  "Search": "搜尋",
  "SearchFor": "搜尋 {0}",
  "ShareQuery": "共用查詢",
  "Preferences": "喜好設定",
  "LinkOpeningSettings": "連結打開設定",
  "Reauthenticate": "重新驗證 {0}",
  "ResultsFilteringExpression": "結果篩選運算式",
  "FiltersInYourPreferences": "喜好設定中的篩選條件",
  "Create": "創建",
  "SearchIn": "在 {0} 中搜尋",
  "Seconds": "用時 {0} 秒",
  "ShowingResultsOf": "結果數 {0}<pl>-{1}</pl>，總數 {2}",
  "ShowingResultsOfWithQuery": "结果数 {0}<pl>-{1}</pl>，总数 {2}, 搜索 {3}",
  "SwitchTo": "切換到 {0}",
  "Unexclude": "不排除 {0}",
  "ClearAllFilters": "清除所有篩選條件",
  "SkipLogin": "跳過登入",
  "LoginInProgress": "正在登入，請稍候...",
  "Login": "登入",
  "GetStarted": "開始體驗",
  "More": "更多",
  "NMore": "{0} 更多...",
  "Less": "更少",
  "Settings": "設定",
  "Score": "得分",
  "ScoreDescription": "得分是根據出現次數和在結果集中的位置計算得來。",
  "Occurrences": "出現次數",
  "OccurrencesDescription": "按出現次數排序，出現次數最高的值排在首位。",
  "Label": "標籤",
  "Of": "第...個，共...個",
  "LabelDescription": "對欄位值按字母順序排序。",
  "Value": "值",
  "ValueDescription": "按第一個計算得出的欄位的值排序",
  "AlphaAscending": "值遞增排序",
  "AlphaDescending": "值遞減排序",
  "ChiSquare": "卡方值",
  "Nosort": "無排序",
  "NosortDescription": "不排序值。值將返回隨機排序。",
  "RelativeFrequency": "相對頻率",
  "RelativeFrequencyDescription": "基於值的相對頻率排序。較不常見的值將出現在較高位置。",
  "DateDistribution": "日期分佈",
  "Custom": "自訂",
  "CustomDescription": "基於自訂順序排序",
  "ComputedField": "計算得出的欄位",
  "Ascending": "遞增",
  "Descending": "遞減",
  "noResultFor": "沒有找到與 {0} 相關的結果",
  "autoCorrectedQueryTo": "查詢自動校正為 {0}",
  "didYouMean": "您要找的是不是： {0}",
  "SuggestedResults": "建議的結果",
  "SuggestedQueries": "建議的查詢",
  "MostRelevantItems": "最相關的項：",
  "AllItems": "所有項：",
  "ShowLess": "顯示較少的值",
  "ShowMore": "顯示較多的值",
  "HideFacet": "隱藏快捷控制介面",
  "ShowFacet": "顯示快捷控制介面",
  "AndOthers": "以及 {0} 個其他項",
  "Others": "{0} 個其他項",
  "MostRelevantPosts": "最相關的公佈內容：",
  "CompleteThread": "完整的主題：",
  "ShowCompleteThread": "顯示完整的主題",
  "ShowOnlyTopMatchingPosts": "僅顯示最匹配的公佈內容",
  "MostRelevantReplies": "最相關的回復：",
  "AllConversation": "所有對話：",
  "ShowAllConversation": "顯示所有對話",
  "ShowAllReplies": "顯示所有回復",
  "ShowOnlyMostRelevantReplies": "僅顯示最相關的回復",
  "Close": "關閉",
  "Open": "打開",
  "OpenInOutlookWhenPossible": "在 Outlook 中打開（如果可能）",
  "AlwaysOpenInNewWindow": "總是在新視窗中打開結果",
  "Quickview": "快速檢視",
  "NoQuickview": "此文檔無法快速瀏覽。",
  "ErrorReport": "錯誤報告",
  "OopsError": "伺服器出現了錯誤。",
  "ProblemPersists": "如果問題仍然存在，請連絡管理員。",
  "GoBack": "返回",
  "Reset": "重設",
  "Retry": "重試",
  "MoreInfo": "更多資訊",
  "Username": "用戶名",
  "Password": "密碼",
  "PostedBy": "公佈者",
  "CannotConnect": "無法連線到該伺服器位址。",
  "BadUserPass": "密碼與用戶名不匹配。",
  "PleaseEnterYourCredentials": "請輸入您的 {0} 認證。",
  "PleaseEnterYourSearchPage": "請輸入您的搜尋網頁 URL",
  "Collapse": "摺疊",
  "Collapsable": "可摺疊",
  "Expand": "展開",
  "Today": "今天",
  "Yesterday": "昨天",
  "Tomorrow": "明天",
  "Duration": "持續時間： {0}",
  "IndexDuration": "索引持續時間： {0}",
  "ProxyDuration": "Proxy 持續時間： {0}",
  "ClientDuration": "用戶端持續時間： {0}",
  "Unavailable": "不可用",
  "Reply": "回復",
  "ReplyAll": "全部回復",
  "Forward": "轉寄",
  "From": "寄件者",
  "Caption": "標題",
  "Expression": "運算式",
  "Tab": "索引標籤",
  "Tabs": "多個索引標籤",
  "EnterExpressionName": "輸入運算式名稱",
  "EnterExpressionToFilterWith": "輸入用於篩選結果的運算式",
  "SelectTab": "選擇索引標籤",
  "SelectAll": "全選",
  "PageUrl": "搜尋網頁 URL",
  "ErrorSavingToDevice": "在將資訊保存到您的設備時出錯",
  "ErrorReadingFromDevice": "在從您的設備讀取資訊時出錯",
  "AppIntro": "諮詢能夠回答您有關 Coveo 的問題的產品專家，並幫助您確定哪個 Coveo 解決方案適合您。或者，嘗試現場示範！",
  "TryDemo": "嘗試示範",
  "ContactUs": "連絡我們",
  "NewToCoveo": "Coveo 的新使用者？",
  "LetUsHelpGetStarted": "讓我們幫助您開始體驗",
  "LikesThis": "{0} 喜歡此解決方案。",
  "CannotConnectSearchPage": "無法連線到您的搜尋網頁",
  "AreYouSureDeleteFilter": "您是否確定要刪除採用 {1} 運算式的篩選條件 {0}",
  "OnlineHelp": "線上說明",
  "Done": "完成",
  "SaveFacetState": "保存此快捷控制介面狀態",
  "ClearFacetState": "清除快捷控制介面狀態",
  "DisplayingTheOnlyMessage": "僅顯示此對話中的消息",
  "NoNetworkConnection": "沒有網路連線",
  "UnknownConnection": "未知的連線",
  "EthernetConnection": "乙太網路連線",
  "WiFi": "WiFi 連線",
  "CELL": "行動電話連線",
  "CELL_2G": "行動電話 2G 連線",
  "CELL_3G": "行動電話 3G 連線",
  "CELL_4G": "行動電話 4G 連線",
  "Relevance": "關聯",
  "Date": "日期",
  "Amount": "數量",
  "QueryExceptionNoException": "沒有例外",
  "QueryExceptionInvalidSyntax": "無效語法",
  "QueryExceptionInvalidCustomField": "無效自訂欄位",
  "QueryExceptionInvalidDate": "無效日期",
  "QueryExceptionInvalidExactPhrase": "無效精確短語",
  "QueryExceptionInvalidDateOp": "無效日期運算子",
  "QueryExceptionInvalidNear": "無效 NEAR 運算子",
  "QueryExceptionInvalidWeightedNear": "無效加權 NEAR",
  "QueryExceptionInvalidTerm": "無效條件",
  "QueryExceptionTooManyTerms": "太多條件",
  "QueryExceptionWildcardTooGeneral": "萬用字元太常見",
  "QueryExceptionInvalidSortField": "無效排序欄位",
  "QueryExceptionInvalidSmallStringOp": "無效小字串運算子",
  "QueryExceptionRequestedResultsMax": "要求的最大結果數",
  "QueryExceptionAggregatedMirrorDead": "遠端聚合鏡像處於離線狀態",
  "QueryExceptionAggregatedMirrorQueryTimeOut": "遠端聚合鏡像查詢超時",
  "QueryExceptionAggregatedMirrorInvalidBuildNumber": "遠程聚合鏡像無效版本號",
  "QueryExceptionAggregatedMirrorCannotConnect": "遠端聚合鏡像無法連線",
  "QueryExceptionNotEnoughLeadingCharsWildcard": "主字元萬用字元不足",
  "QueryExceptionSecurityInverterNotFound": "未找到安全變換器",
  "QueryExceptionSecurityInverterAccessDenied": "安全變換器存取被拒絕",
  "QueryExceptionAggregatedMirrorCannotImpersonate": "遠端聚合鏡像無法模擬",
  "QueryExceptionUnexpected": "意外",
  "QueryExceptionAccessDenied": "存取被拒絕",
  "QueryExceptionSuperUserTokenInvalid": "進階使用者權杖無效",
  "QueryExceptionSuperUserTokenExpired": "進階使用者權杖已過期",
  "QueryExceptionLicenseQueriesExpired": "查詢授權已過期",
  "QueryExceptionLicenseSuperUserTokenNotSupported": "授權進階使用者權杖不支援",
  "QueryExceptionInvalidSession": "無效會話",
  "QueryExceptionInvalidDocument": "無效文件",
  "QueryExceptionSearchDisabled": "搜尋被禁用",
  "FileType": "檔案類型",
  "ShowAttachment": "顯示附件",
  "OnFeed": "有關 {0} 的輸入。",
  "Author": "作者",
  "NoTitle": "無標題",
  "CurrentSelections": "當前選擇",
  "AllContent": "所有內容",
  "CancelLastAction": "取消最後一個動作",
  "SearchTips": "搜尋提示",
  "CheckSpelling": "檢查關鍵字的拼寫。",
  "TryUsingFewerKeywords": "嘗試使用更少、更常用或不同的關鍵字。",
  "SelectFewerFilters": "選擇較少的篩選條件以擴大您的搜尋範圍。",
  "Document": "文件",
  "Time": "時間",
  "StartDate": "開始日期",
  "StartTime": "啟動時間",
  "DurationTitle": "持續時間",
  "UserQuery": "用戶查詢",
  "ShowUserActions": "顯示用戶操作",
  "NoData": "無可用資料",
  "EventType": "事件類型",
  "GoToFullSearch": "全面搜尋",
  "GoToEdition": "定制儀錶板",
  "RemoveContext": "刪除上下文",
  "BoxAttachToCase": "加入實例",
  "AttachToCase": "加入實例",
  "Attach": "附件",
  "Attached": "附上",
  "Detach": "分離",
  "Details": "詳細說明",
  "AdditionalFilters": "額外的篩選器",
  "SelectNonContextualSearch": "於目前記錄中刪除上下文以擴大搜尋範圍",
  "CopyPasteToSupport": "將此消息複製粘貼到柯維歐支援小組以獲取更多資訊。",
  "FollowQueryDescription": "提醒我對此查詢的搜尋結果的更改。",
  "SearchAlerts_Panel": "管理通告",
  "SearchAlerts_PanelDescription": "查看並管理您的搜尋通告",
  "SearchAlerts_PanelNoSearchAlerts": "您沒有訂閱",
  "SearchAlerts_Fail": "搜尋通告服務目前無法使用.",
  "SearchAlerts_Type": "類型",
  "SearchAlerts_Content": "內容",
  "SearchAlerts_Actions": "動作",
  "EmptyQuery": "<清空>",
  "SearchAlerts_Type_followQuery": "查詢",
  "SearchAlerts_Type_followDocument": "項",
  "SearchAlerts_unFollowing": "停止關注",
  "SearchAlerts_follow": "按照",
  "SearchAlerts_followed": "緊隨",
  "SearchAlerts_followQuery": "按照查詢",
  "Subscription_StopFollowingQuery": "停止以下查詢",
  "SearchAlerts_Frequency": "什麼時間",
  "SubscriptionsManageSubscriptions": "管理通告",
  "SubscriptionsMessageFollowQuery": "當查詢<b> {0} </ b>恢復新專案或更動專案時，您將收到提示。",
  "SubscriptionsMessageFollow": "您會收到有關專案<b> {0} </ b>的更改的提醒。",
  "Expiration": "期滿",
  "Monthly": "每月一次",
  "Daily": "每日一次",
  "Monday": "星期一",
  "Tuesday": "星期二",
  "Wednesday": "星期三",
  "Thursday": "週四",
  "Friday": "星期五",
  "Saturday": "星期六",
  "Sunday": "周日",
  "NextDay": "下一頁{0}",
  "LastDay": "最後一頁{0}",
  "StartTypingCaseForSuggestions": "描述你的問題，參見可能的解決方案",
  "ExportToExcel": "匯出到 Excel",
  "ExportToExcelDescription": "將搜尋結果匯出到 Excel",
  "CaseCreationNoResults": "沒有找到推薦的解決方案",
  "SortBy": "排序依據",
  "BoxCreateArticle": "創建文章",
  "Facets": "快捷控制介面",
  "AdvancedSearch": "高級搜尋",
  "Keywords": "關鍵字",
  "AllTheseWords": "所有這些詞語",
  "ExactPhrase": "這個確切詞",
  "AnyOfTheseWords": "所有這些詞語",
  "NoneOfTheseWords": "無這些詞語",
  "Anytime": "任何時間",
  "InTheLast": "最後",
  "Days": "天數",
  "Months": "月份",
  "Month": "月份",
  "Year": "年度",
  "Between": "介於",
  "Language": "語言設定",
  "Size": "規格",
  "AtLeast": "最低限度",
  "AtMost": "最高限度",
  "Contains": "含有",
  "DoesNotContain": "不含",
  "Matches": "匹配",
  "Bytes": "位元組",
  "card": "卡片",
  "table": "表格",
  "ResultLinks": "結果頁面的連結",
  "EnableQuerySyntax": "啟用查詢語法",
  "On": "打開",
  "Off": "關閉",
  "Automatic": "自動",
  "ResultsPerPage": "每頁的結果數",
  "PreviousMonth": "前一個月",
  "NextMonth": "下個月",
  "Title": "題目",
}

  var locales = String["locales"] || (String["locales"] = {});
  locales["zh-TW"] = merge(locales["zh-TW"], dict);
  String["toLocaleString"].call(this, { "zh-TW": dict });
  String["locale"] = "zh-TW";
  String["defaultLocale"] = "en";
  Globalize.culture("zh-TW")
}